/******************************************************************************
											Copyright (c) Freescale 2002
File Name		 :	$RCSfile: EE_emulation.h,v $		
	
Engineer		 :	$Author: r27624 $

Location		 :	EKB

Date Created	 :	04/03/2002

Current Revision :	$Revision: 1.1 $

Notes	:					

*******************************************************************************
Freescale reserves the right to make changes without further notice to any
product	herein to improve reliability, function	or design. Freescale does not
assume any liability arising out of the	application or use of any product,
circuit, or software described	herein;	neither	does it	convey any license
under its patent rights	nor the rights of others. Freescale products are	not
designed, intended, or authorized for use as components in systems intended for
surgical implant into the body, or other applications intended to support life,
or for any other application in which the failure of the  Freescale product
could create a	situation where	personal injury	or death may occur. Should
Buyer purchase or use Freescale products for any such unintended or
unauthorized application, Buyer shall idemnify and hold Freescale and its
officers, employees, subsidiaries, affiliates, and distributors	harmless
against	all claims costs, damages, and expenses, and reasonable	attorney fees 
arising	out of,	directly or indirectly,	any claim of personal injury or	death
associated with	such unintended	or unauthorized use, even if such claim alleges
that Freescale was negligent regarding the design or manufacture	of the part.
Freescale and the Freescale logo*	are registered trademarks of Freescale Ltd.
******************************************************************************/

#if !defined(EE_EMULATION_H)
#define EE_EMULATION_H

/************************* Include Files *************************************/
#include "ee_emulation.h"

/************************* typedefs ******************************************/

/************************* #Defines ******************************************/

/* If it is required to service interrupts during programming and erasure,
   IRQ_DURING_PROG must be defined, either here or on the compiler command line */
   
/* #define IRQ_DURING_PROG */

/*****************************************************************************
NOTE: 

EEPROM_SIZE_BYTES = 2, 6, 14, 30, 62, 126, (m * 256) - 2, m = 1, 2, 3...

if EEPROM_SIZE_BYTES < 256
EEPROM_BANKS = n * 256 / (EEPROM_SIZE_BYTES + 2), n = 2, 3, 4, ...
 
EEPROM_SIZE_BYTES >= 256
EEPROM_BANKS = 2, 3, 4...
******************************************************************************/

										/* number of bytes of emulated eeprom */
#define EEPROM_SIZE_BYTES		126	
										/* number of eeprom banks */
#define EEPROM_BANKS			8	

/* THE FOLLOWING MUST MATCH ADDRESSES USED IN PRM FILE */

										/* start address of emulated eeprom area */ 
#define EEPROM_START 			EED_FLASH_START_ADDRESS

#ifndef PASS
#define PASS 0u
#endif

#ifndef FAIL
#define FAIL 1u
#endif

#ifndef SET
#define SET 1u
#endif


#ifndef CLEAR
#define CLEAR 0u
#endif

/************************* External Variables ********************************/

/************************* Prototypes ******************************************/
#pragma CODE_SEG DEFAULT

void  InitEeprom(void);
UINT16 WriteEeprom(void *SSD_SGF18_FAR, void*, UINT16);
void  ReadEeprom(void*SSD_SGF18_FAR, void*, UINT16);

/************************* Macros **********************************************/


#endif  /* EE_EMULATION_H defined */

